/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;

public class JUnitEEWarTask
extends War {
    private static final String URLPATTERN_TOKEN = "@urlPattern@";
    private static final String URLPATTERN_REPLACEMENT = "TestServlet";
    private static final String WEBXML_URLPATTERN = "/TestServlet/*";
    private static final String WEBXML_DOCTYPE_2_2 = "web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN\" \"http://java.sun.com/j2ee/dtds/web-app_2_2.dtd\"";
    private static final String WEBXML_DOCTYPE_2_3 = "web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\"";
    private static final String WEBXML_DISPLAY_NAME = "JunitServletRunner Application";
    private static final String WEBXML_SERVLET_NAME = "JUnitEETestServlet";
    private static final String WEBXML_SERVLET_CLASS = "org.junitee.servlet.JUnitEEServlet";
    private static final int DEFAULT_HTML_REFRESH_DELAY = 2;
    private int htmlRefreshDelay = 2;
    private String testjarname;
    private String servletclass = "org.junitee.servlet.JUnitEEServlet";
    private List testCases = new ArrayList();
    private List classes = new ArrayList();
    private List ejbRefs = new ArrayList();
    private List ejbLocalRefs = new ArrayList();
    private List resRefs = new ArrayList();
    private File deploymentDescriptor;

    public void setHtmlRefreshDelay(String htmlRefreshDelay) {
        try {
            this.htmlRefreshDelay = Integer.parseInt(htmlRefreshDelay);
        }
        catch (NumberFormatException e) {
            this.htmlRefreshDelay = 2;
        }
    }

    public void setTestjarname(String name) {
        this.testjarname = name;
    }

    public void setServletclass(String servletclass) {
        this.servletclass = servletclass;
    }

    public void setWebxml(File descr) {
        this.deploymentDescriptor = descr;
        super.setWebxml(descr);
    }

    public void addClasses(ZipFileSet fs) {
        this.classes.add(fs);
    }

    public void addTestCases(FileSet fs) {
        this.testCases.add(fs);
    }

    public EjbRef createEjbRef() {
        EjbRef ejbRef = new EjbRef();
        this.ejbRefs.add(ejbRef);
        return ejbRef;
    }

    public EjbLocalRef createEjbLocalRef() {
        EjbLocalRef ejbRef = new EjbLocalRef();
        this.ejbLocalRefs.add(ejbRef);
        return ejbRef;
    }

    public ResRef createResourceRef() {
        ResRef ref = new ResRef();
        this.resRefs.add(ref);
        return ref;
    }

    private void check() throws BuildException {
        if (this.testjarname != null && !this.testjarname.endsWith(".jar")) {
            this.testjarname = this.testjarname + ".jar";
        }
        Iterator i = this.ejbRefs.iterator();
        while (i.hasNext()) {
            EjbRef ejbRef = (EjbRef)i.next();
            ejbRef.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File lstTestFile;
        File jarFile;
        File indexHtmlFile;
        block13: {
            File webXmlFile = null;
            indexHtmlFile = null;
            jarFile = null;
            lstTestFile = null;
            this.check();
            try {
                ZipFileSet fs;
                if (this.deploymentDescriptor == null) {
                    webXmlFile = this.createWebXml();
                    this.setWebxml(webXmlFile);
                }
                if (this.testjarname != null) {
                    jarFile = this.buildClassesJar();
                    fs = new ZipFileSet();
                    fs.setDir(new File(jarFile.getParent()));
                    fs.setIncludes(jarFile.getName());
                    fs.setFullpath("WEB-INF/lib/" + this.testjarname);
                    this.addFileset((FileSet)fs);
                } else {
                    Iterator iterator = this.classes.iterator();
                    while (iterator.hasNext()) {
                        ZipFileSet zipFileSet = (ZipFileSet)iterator.next();
                        super.addClasses(zipFileSet);
                    }
                }
                indexHtmlFile = this.createIndexHtml();
                fs = new ZipFileSet();
                fs.setDir(new File(indexHtmlFile.getParent()));
                fs.setIncludes(indexHtmlFile.getName());
                fs.setFullpath("index.html");
                this.addFileset((FileSet)fs);
                lstTestFile = this.createTestCaseList();
                fs = new ZipFileSet();
                fs.setDir(new File(lstTestFile.getParent()));
                fs.setIncludes(lstTestFile.getName());
                fs.setFullpath("WEB-INF/testCase.txt");
                this.addFileset((FileSet)fs);
                super.execute();
                Object var9_8 = null;
                if (webXmlFile == null) break block13;
                webXmlFile.delete();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (webXmlFile != null) {
                    webXmlFile.delete();
                }
                if (indexHtmlFile != null) {
                    indexHtmlFile.delete();
                }
                if (jarFile != null) {
                    jarFile.delete();
                }
                if (lstTestFile != null) {
                    lstTestFile.delete();
                }
                throw throwable;
            }
        }
        if (indexHtmlFile != null) {
            indexHtmlFile.delete();
        }
        if (jarFile != null) {
            jarFile.delete();
        }
        if (lstTestFile != null) {
            lstTestFile.delete();
        }
    }

    private File buildClassesJar() throws BuildException {
        this.log("Building test.jar ...", 4);
        try {
            File jarFile = File.createTempFile("classes", "jar");
            Jar jar = (Jar)this.getProject().createTask("jar");
            jar.setDestFile(jarFile);
            Iterator i = this.classes.iterator();
            while (i.hasNext()) {
                ZipFileSet fs = (ZipFileSet)i.next();
                jar.addFileset((FileSet)fs);
            }
            jar.execute();
            return jarFile;
        }
        catch (IOException ex) {
            throw new BuildException("Error creating web.xml", (Throwable)ex);
        }
    }

    private File createWebXml() throws BuildException {
        try {
            AbstractEjbRef ejbRef;
            File webXmlFile = File.createTempFile("web", "xml");
            webXmlFile.createNewFile();
            PrintWriter pw = new PrintWriter(new FileOutputStream(webXmlFile));
            pw.println("<?xml version=\"1.0\"?>");
            if (this.ejbLocalRefs.isEmpty()) {
                pw.println("<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN\" \"http://java.sun.com/j2ee/dtds/web-app_2_2.dtd\">");
            } else {
                pw.println("<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">");
            }
            pw.println("");
            pw.println("<web-app>");
            pw.println("  <display-name>JunitServletRunner Application</display-name>");
            pw.println("");
            pw.println("  <servlet>");
            pw.println("    <servlet-name>JUnitEETestServlet</servlet-name>");
            pw.println("    <description>JUnitEE test harness</description>");
            pw.println("    <servlet-class>" + this.servletclass + "</servlet-class>");
            pw.println("    <init-param>");
            pw.println("      <param-name>htmlRefreshDelay</param-name>");
            pw.println("      <param-value>" + this.htmlRefreshDelay + "</param-value>");
            pw.println("    </init-param>");
            pw.println("  </servlet>");
            pw.println("");
            pw.println("  <servlet-mapping>");
            pw.println("    <servlet-name>JUnitEETestServlet</servlet-name>");
            pw.println("    <url-pattern>/TestServlet/*</url-pattern>");
            pw.println("  </servlet-mapping>");
            pw.println("");
            Iterator i = this.resRefs.iterator();
            while (i.hasNext()) {
                ResRef ref = (ResRef)i.next();
                pw.println("");
                pw.println("  <resource-ref>");
                pw.println("    <res-ref-name>" + ref.getResRefName() + "</res-ref-name>");
                pw.println("    <res-type>" + ref.getResType() + "</res-type>");
                pw.println("    <res-auth>" + ref.getResAuth() + "</res-auth>");
                pw.println("  </resource-ref>");
            }
            i = this.ejbRefs.iterator();
            while (i.hasNext()) {
                ejbRef = (EjbRef)i.next();
                pw.println("");
                pw.println("  <ejb-ref>");
                pw.println("    <ejb-ref-name>" + ejbRef.getEjbRefName() + "</ejb-ref-name>");
                pw.println("    <ejb-ref-type>" + ejbRef.getEjbRefType() + "</ejb-ref-type>");
                pw.println("    <home>" + ((EjbRef)ejbRef).getHome() + "</home>");
                pw.println("    <remote>" + ((EjbRef)ejbRef).getRemote() + "</remote>");
                if (ejbRef.getEjbLink() != null) {
                    pw.println("    <ejb-link>" + ejbRef.getEjbLink() + "</ejb-link>");
                }
                pw.println("  </ejb-ref>");
            }
            i = this.ejbLocalRefs.iterator();
            while (i.hasNext()) {
                ejbRef = (EjbLocalRef)i.next();
                pw.println("");
                pw.println("  <ejb-local-ref>");
                pw.println("    <ejb-ref-name>" + ejbRef.getEjbRefName() + "</ejb-ref-name>");
                pw.println("    <ejb-ref-type>" + ejbRef.getEjbRefType() + "</ejb-ref-type>");
                pw.println("    <local-home>" + ((EjbLocalRef)ejbRef).getLocalHome() + "</local-home>");
                pw.println("    <local>" + ((EjbLocalRef)ejbRef).getLocal() + "</local>");
                if (ejbRef.getEjbLink() != null) {
                    pw.println("    <ejb-link>" + ejbRef.getEjbLink() + "</ejb-link>");
                }
                pw.println("  </ejb-local-ref>");
            }
            pw.println("</web-app>");
            pw.close();
            return webXmlFile;
        }
        catch (IOException ex) {
            throw new BuildException("Error creating web.xml", (Throwable)ex);
        }
    }

    private File createIndexHtml() throws BuildException {
        try {
            String line;
            File file = File.createTempFile("index", "html");
            file.createNewFile();
            PrintWriter pw = new PrintWriter(new FileOutputStream(file));
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("index.html");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer bufferList = new StringBuffer();
            Iterator i = this.testCases.iterator();
            while (i.hasNext()) {
                FileSet fs = (FileSet)i.next();
                DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
                String[] files = scanner.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String className = this.getTestCaseClassName(files[j]);
                    bufferList.append("        <tr><td class=\"cell\"><input type=\"checkbox\" name=\"suite\" value=\"");
                    bufferList.append(className).append("\">&nbsp;&nbsp;").append(className).append("</td></tr>\n");
                }
            }
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("<!-- ### -->")) {
                    pw.print(bufferList.toString());
                    continue;
                }
                int index = line.indexOf(URLPATTERN_TOKEN);
                if (index != -1) {
                    pw.print(line.substring(0, index));
                    pw.print(URLPATTERN_REPLACEMENT);
                    pw.println(line.substring(index + URLPATTERN_TOKEN.length()));
                    continue;
                }
                pw.println(line);
            }
            reader.close();
            pw.close();
            return file;
        }
        catch (IOException ex) {
            throw new BuildException("Error creating index.html", (Throwable)ex);
        }
    }

    private File createTestCaseList() throws BuildException {
        try {
            File file = File.createTempFile("testcase", "txt");
            file.createNewFile();
            PrintWriter pw = new PrintWriter(new FileOutputStream(file));
            pw.println("# JunitServletRunner");
            Iterator i = this.testCases.iterator();
            while (i.hasNext()) {
                FileSet fs = (FileSet)i.next();
                DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
                String[] files = scanner.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String className = this.getTestCaseClassName(files[j]);
                    pw.println(className);
                }
            }
            pw.close();
            return file;
        }
        catch (IOException ex) {
            throw new BuildException("Error creating test case list", (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getTestCaseClassName(String fileName) throws BuildException {
        void var3_3;
        int lenSuffix;
        String name = fileName.replace(File.separatorChar, '.');
        if (name.endsWith(".class")) {
            lenSuffix = 6;
        } else if (name.endsWith(".java")) {
            lenSuffix = 5;
        } else {
            throw new BuildException("TestCase (" + fileName + ") must be .class or .java files");
        }
        String className = name.substring(0, name.length() - var3_3);
        return className;
    }

    public class ResRef {
        private String resRefName;
        private String resType;
        private String resAuth;

        public String getResRefName() {
            return this.resRefName;
        }

        public void setResRefName(String resRefName) {
            this.resRefName = resRefName;
        }

        public String getResType() {
            return this.resType;
        }

        public void setResType(String resType) {
            this.resType = resType;
        }

        public String getResAuth() {
            return this.resAuth;
        }

        public void setResAuth(String resAuth) {
            this.resAuth = resAuth;
        }
    }

    public class EjbLocalRef
    extends AbstractEjbRef {
        private String localHome;
        private String local;

        public String getLocalHome() {
            return this.localHome;
        }

        public void setLocalHome(String localHome) {
            this.localHome = localHome;
        }

        public String getLocal() {
            return this.local;
        }

        public void setLocal(String local) {
            this.local = local;
        }

        public void check() throws BuildException {
            super.check();
            if (this.localHome == null) {
                throw new BuildException("You must specify the localhome attribute", JUnitEEWarTask.this.location);
            }
            if (this.local == null) {
                throw new BuildException("You must specify the local attribute", JUnitEEWarTask.this.location);
            }
        }
    }

    public class EjbRef
    extends AbstractEjbRef {
        private String home;
        private String remote;

        String getHome() {
            return this.home;
        }

        public void setHome(String home) {
            this.home = home;
        }

        String getRemote() {
            return this.remote;
        }

        public void setRemote(String remote) {
            this.remote = remote;
        }

        public void check() throws BuildException {
            super.check();
            if (this.home == null) {
                throw new BuildException("You must specify the home attribute", JUnitEEWarTask.this.location);
            }
            if (this.remote == null) {
                throw new BuildException("You must specify the remote attribute", JUnitEEWarTask.this.location);
            }
        }
    }

    public abstract class AbstractEjbRef {
        private String ejbRefName;
        private String ejbRefType;
        private String ejbLink;

        String getEjbRefName() {
            return this.ejbRefName;
        }

        public void setEjbRefName(String ejbRefName) {
            this.ejbRefName = ejbRefName;
        }

        String getEjbRefType() {
            return this.ejbRefType;
        }

        public void setEjbRefType(String ejbRefType) {
            this.ejbRefType = ejbRefType;
        }

        String getEjbLink() {
            return this.ejbLink;
        }

        public void setEjbLink(String ejbLink) {
            this.ejbLink = ejbLink;
        }

        public void check() throws BuildException {
            if (this.ejbRefName == null) {
                throw new BuildException("You must specify the ejbRefName attribute", JUnitEEWarTask.this.location);
            }
            if (this.ejbRefType == null) {
                throw new BuildException("You must specify the ejbRefType attribute", JUnitEEWarTask.this.location);
            }
        }
    }
}

